//  PCAN-UDS.h
//
//  ~~~~~~~~~~~~
//
//  PCAN-UDS API 2013 (ISO 14229-1:2013)
//
//  ~~~~~~~~~~~~
//
//  ------------------------------------------------------------------
//  Last changed by:    $Author: Fabrice $
//  Last changed date:  $Date: 2025-01-24 11:02:27 +0100 (Fri, 24 Jan 2025) $
//
//  Language: ANSI-C
//  ------------------------------------------------------------------
//
//  Copyright (C) 2015  PEAK-System Technik GmbH, Darmstadt
//  more Info at http://www.peak-system.com
//

#ifndef __PCANUDS_DEFS_H__
#define __PCANUDS_DEFS_H__

// Defines the version of the API based on the ISO revision
#define PUDS_API_COMPATIBILITY_ISO_2006 2006
#define PUDS_API_COMPATIBILITY_ISO_2013 2013

////////////////////////////////////////////
// Backward compatibility notes:
//    By default PCAN-UDS API retains
//    PCAN-UDS "ISO rev. 2006" (<1.x) prototypes.
//
//    To enable as default 2013 prototypes just define the macro PUDS_API_COMPATIBILITY
//    before including PCAN-UDS API headers.
//
//    Example:
//        #define PUDS_API_COMPATIBILITY PUDS_API_COMPATIBILITY_ISO_2013
//        #include "PCAN-UDS.h"
#if !defined(PUDS_API_COMPATIBILITY)
#define PUDS_API_COMPATIBILITY PUDS_API_COMPATIBILITY_ISO_2006
#endif

// >>> PCAN-UDS 1.x backward compatibility
#if defined(PUDS_API_COMPATIBILITY) && (PUDS_API_COMPATIBILITY == PUDS_API_COMPATIBILITY_ISO_2006)
    #ifdef __linux__
        #ifdef __cplusplus
            #include <cstdint>
        #else
            #include <stdint.h>
        #endif
        #ifndef __stdcall
        #define __stdcall
        #endif
        #ifndef BYTE
            #define BYTE uint8_t
        #endif
        #ifndef WORD
            #define WORD uint16_t
        #endif
        #ifndef DWORD
            #define DWORD uint32_t
        #endif
        #ifndef BOOLEAN
            #define BOOLEAN BYTE
        #endif
        #ifndef BOOL
            #define BOOL int
        #endif
    #else
        // Check types defined in Windows header (required by PCAN-UDS_2004)
        #if !defined(BYTE) || !defined(WORD) || !defined(DWORD) || !defined(LPSTR) || !defined(UINT64)
        #define WIN32_LEAN_AND_MEAN
        #include <Windows.h>
    #endif
#endif
// Include header for ISO-14229-1:2006
#ifdef __clang__
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wnewline-eof"
#endif
#include "PCAN-UDS_2006.h"
#ifdef __clang__
#pragma clang diagnostic pop
#endif
#endif // <<< PCAN-UDS 1.x backward compatibility

// Include header for ISO-14229-1:2013
#ifdef __clang__
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wreserved-identifier"
#endif
#include "PCAN-UDS_2013.h"
#ifdef __clang__
#pragma clang diagnostic pop
#endif

#endif
